# ION_GNSS_2024_Dataset

This project contains the dataset created and used for the ION GNSS+ 2024 paper entitled "Assessing GNSS Spoofing Impact on A Safety-Critical Land Transportation Localization Function Within a Cooperative Fleet: An End-Users Focused Experimental Study":
- <a href="https://www.ion.org/gnss/abstracts.cfm?paperID=13780"> Abstract </a>

It contains the information of three instrumented Renault Zoé cars of the <a href="https://www.cristal.univ-lille.fr/pretil/">PRETIL</a> plateform, CRIStAL laboratory of University of Lille.

The cars are equipped with perception sensors, GNSS receivers and inertial measurement units, as well as access to the ABS system via the can bus.

Dépôt : <a href="https://entrepot.recherche.data.gouv.fr/dataverse/cristal-pretil">Entrepôt PRETIL</a>

# Overall Behaviour
| rosbag                                                               | time |  Start time             |   Size   |  KM  |  ID       |
|----------------------------------------------------------------------|------|-------------------------|----------|------|-----------|
|./blanche/2024-07-05/blanche_run1/2024-07-05-15-29-44.bag             |501s  | Jul 05 2024 15:29:44.92 | 30.3 GB  | 3.7  |  ION_CAR1 |
|./bleue/5-07-2024/5-07-2024_0.db3                                     |522.5s| Jul 05 2024 15:29:37.643| 62.2 GB  | 3.5  |  ION_CAR2 |
|./Grise/rosbag2_2024_07_05-15_29_49/rosbag2_2024_07_05-15_29_49_0.db3 |530.2s| Jul 05 2024 15:29:49.638| 30.2 GB  | 2.5  |  ION_CAR3 |

# Car 1 (White)

Configured under ROS1

## Topics

| Topics                       |  Message                     | HZ  |   sensor            |
|------------------------------|------------------------------|-----|---------------------|
| /scan                        | sensor_msgs/LaserScan        | 10  | LADDAR              |
| /novatel/oem7/fix            | sensor_msgs/NavSatFix        | 30  | Novatel PwrpakD-E2  |
| /novatel/oem7/imu/data       | sensor_msgs/Imu              | 100 | Novatel PwrpakD-E2  |
| /yost3/imu                   | sensor_msgs/Imu              | 200 | YOST3               |
| /d435i/accel/sample          | sensor_msgs/Imu              | 63  | IntelRealSense D435i|
| /d435i/gyro/sample           | sensor_msgs/Imu              | 200 | IntelRealSense D435i|
| /velodyne_points             | sensor_msgs/PointCloud2      | 10  | Velodyne vlp16_01   |
| /hesai/lidar_points          | sensor_msgs/PointCloud2      | 10  | Hesai PandarXT-32   |
| /m8t/fix                     | sensor_msgs/NavSatFix        | 1   |  Ublox EVK M8T      |
| /m8t/rxmraw                  | /ublox/RXMRAWX               | 1   |  Ublox EVK M8T      |
| /can/odom                    | can_zoe_msgs/Odom            | 200 |  CAN_01             |
| /can/speed                   | can_zoe_msgs/Speed           | 100 |  CAN_01             |
| /can/steering                | can_zoe_msgs/Steering        | 100 |  CAN_01             |

## Trajectory

<img src="CAR1_TRAJ.png">

# Car 2 (Blue)

Configured under ROS2

## Topics

| Topics                       |  Message                     | HZ  |   sensor            |
|------------------------------|------------------------------|-----|---------------------|
| /sick_mrs_6xxx/cloud         | sensor_msgs/msg/PointCloud2  | 10  |  SICK               |
| /novatel/oem7/fix            | sensor_msgs/msg/NavSatFix    | 50  | Novatel PwrpakD-E2  |
| /novatel/oem7/imu/data       | sensor_msgs/msg/Imu          | 100 | Novatel PwrpakD-E2  |
| /yost3/imu                   | sensor_msgs/msg/Imu          | 200 | YOST3               |
| /hesai/lidar_points          | sensor_msgs/msg/PointCloud2  | 10  | Hesai PandarXT-32   |
| /m8t/fix                     | sensor_msgs/msg/NavSatFix    | 1   |  Ublox EVK M8T      |
| /m8t/rxmraw                  | /ublox/msg/RXMRAWX           | 1   |  Ublox EVK M8T      |
| /sbg/imu_data                | sensor_msgs/msg/Imu          | 10  | SBG Ellipse         |
| /can/options1                | can_zoe_msgs/msg/Options1    | 50  |  CAN_02             |
| /can/options2                | can_zoe_msgs/msg/Options2    | 50  |  CAN_02             |
| /can/options3                | can_zoe_msgs/msg/Options3    | 10  |  CAN_02             |


## Trajectory

<img src="CAR2_TRAJ.png">

# Car 3 (Grey)

Configured under ROS2

## Topics

| Topics                           |  Message                     | HZ  |   sensor            |
|----------------------------------|------------------------------|-----|---------------------|
| /sick_mrs_6xxx/sick_mrs_6xxx/scan| sensor_msgs/msg/PointCloud2  | 10  |  SICK               |
| /novatel/oem7/fix                | sensor_msgs/msg/NavSatFix    | 50  | Novatel PwrpakD-E2  |
| /novatel/oem7/imu/data           | sensor_msgs/msg/Imu          | 100 | Novatel PwrpakD-E2  |
| /yost/imu                        | sensor_msgs/msg/Imu          | 200 | YOST3               |
| /d435i/accel/sample              | sensor_msgs/msg/Imu          | 63  | IntelRealSense D435i|
| /d435i/gyro/sample               | sensor_msgs/msg/Imu          | 200 | IntelRealSense D435i|
| /hesai/lidar_points              | sensor_msgs/msg/PointCloud2  | 10  | Hesai PandarXT-32   |
| /m8t/fix                         | sensor_msgs/msg/NavSatFix    | 1   |  Ublox EVK M8T      |
| /m8t/rxmraw                      | /ublox/msg/RXMRAWX           | 1   |  Ublox EVK M8T      |
| /sbg/imu/data                    | sensor_msgs/msg/Imu          | 200 | SBG Ellipse         |
| /can/options1                    | can_zoe_msgs/msg/Options1    | 50  |  CAN_03             |
| /can/options2                    | can_zoe_msgs/msg/Options2    | 50  |  CAN_03             |
| /can/options3                    | can_zoe_msgs/msg/Options3    | 10  |  CAN_03             |

## Trajectory

<img src="CAR3_TRAJ.png">



