#!/bin/bash
# Execute in a fresh Prelude directory to avoid garbage to come with.

VERSION=`grep Version _oasis | sed "s/Version:[' ']*//"`
ARCH=`uname -m`
if [ "x86_64" = "${ARCH}" ];
then 
    PLATFORM=linux-64
else
    PLATFORM=linux-32
fi
DISTRIB_DIR=prelude-$VERSION

# Build if needed
./configure --prefix $DISTRIB_DIR
make all

# binaries
make install

# libraries
mkdir -p $DISTRIB_DIR/lib
mkdir -p $DISTRIB_DIR/lib/prelude
cp lib/prelude/* $DISTRIB_DIR/lib/prelude/

# examples
mkdir -p $DISTRIB_DIR/Examples
cp Exemples/*.plu $DISTRIB_DIR/Examples
mkdir -p $DISTRIB_DIR/Examples/sampling_loop
cp Exemples/sampling_loop/* $DISTRIB_DIR/Examples/sampling_loop

# doc
TODAY=`date +"%F"`
sed -e "s/PLATFORM/$PLATFORM/" -e "s/VERSION/$VERSION/" -e "s/DATE/$TODAY/" INSTALL > INSTALL-$PLATFORM
mv INSTALL-$PLATFORM $DISTRIB_DIR/INSTALL
cp README $DISTRIB_DIR

# pack everything
tar cvfz prelude-$VERSION-$PLATFORM.tgz $DISTRIB_DIR
