/* This file is a generic integration code that translates a task set
 * generated by Prelude into a set of C threads, scheduled by an
 * improved EDF policy supporting deadline words. The scheduler is
 * implemented using MaRTE OS. The threads are built using primitives
 * specific to MaRTE.
 *
 * ABOUT DURATIONS: We expects programs with durations in milliseconds
 * This code is generic but still requires to change an include to
 * execute your own program. See below.
 *  
 * ----------------------------------------------------------------------
 *  Copyright (C) 2009-2010, ONERA, FRANCE - LIFL, Lile, FRANCE
 *  
 *  Contact Address: Julien Forget       julien.forget@polytech-lille.fr
 *
 * This code is free software; you can  redistribute it and/or  modify it
 * under the terms of the GNU General Public License  as published by the
 * Free Software Foundation;  either  version 2, or (at  your option) any
 * later version.
 *
 * This code is distributed  in the  hope  that  it will be   useful, but
 * WITHOUT  ANY  WARRANTY;     without  even the   implied   warranty  of
 * MERCHANTABILITY  or  FITNESS FOR A  PARTICULAR PURPOSE.    See the GNU
 * General Public License for more details.
 *
 * You should have received  a  copy of  the  GNU General Public  License
 * distributed with this file;  see file COPYING.   If not,  write to the
 * Free Software  Foundation,  59 Temple Place  -  Suite 330,  Boston, MA
 * 02111-1307, USA.
 *
 * As a  special exception, if you  link this  unit  with other  files to
 * produce an  executable,   this unit  does  not  by  itself cause  the
 * resulting executable to be covered by the  GNU General Public License.
 * This exception does  not however invalidate  any other reasons why the
 * executable file might be covered by the GNU Public License.
 *
 *---------------------------------------------------------------------------*/

#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <pthread.h>
#include <sched.h>
#include <misc/load.h>
#include <misc/error_checks.h>
#include <misc/timespec_operations.h>
#include "edf_word_sched.h"
#include "task_params.h"
// TO REPLACE: Include the header generated by preludec for your prelude
// program below:
#include "sampling_c/sampling.h"

/* Takes a task_param value and packs its body function (generated by
   prelude) inside an infinite while. The resulting function is the one
   to be called by the thread built for this task. */
void* pack(void* args)
{
  struct task_params* task = (struct task_params*) args;

  while (1)
    {
      // The actual function of the task
      task->task_body(args);
      // The following instruction is more a debug instruction, it can be
      // removed if your tasks really take time to execute.
      eat((float)(task->wcet)*0.001);
      // Signal the end of the current task instance. This will cause
      // the scheduler to suspend the thread until the next task release.
      posix_appsched_invoke_scheduler (0);
    }
}

#define MAIN_PRIO 5
int main ()
{
  pthread_attr_t attr;
  struct sched_param param;
  struct edf_sched_param user_param;
  pthread_t sched;
  
  adjust ();
  
  /* Set main task base priority */
  param.sched_priority = MAIN_PRIO;
  CHK( pthread_setschedparam (pthread_self (), SCHED_FIFO, &param) );
  
  /* Create the scheduler thread */
  pthread_attr_init (&attr);
  pthread_attr_setschedpolicy (&attr, SCHED_FIFO);
  pthread_attr_setappschedulerstate (&attr, PTHREAD_APPSCHEDULER);
  param.sched_priority = MAIN_PRIO - 1;
  CHK( pthread_attr_setschedparam (&attr, &param) );
  CHK( pthread_create (&sched, &attr, edf_scheduler, NULL) );
  pthread_attr_destroy(&attr);
  
  /* Create the threads for prelude tasks */
  int task_number;
  struct task_params* task_set;
  get_task_set(&task_number,&task_set);
  pthread_t prelude_threads[task_number];

  int i;
  for(i=0;i<task_number;i++) {
    pthread_attr_init (&attr);
    pthread_attr_setschedpolicy (&attr, SCHED_APP);
    CHK( pthread_attr_setappscheduler (&attr, sched) );
    double_to_timespec((double)(task_set[i].period)*0.001,&(user_param.period));
    double_to_timespec((double)(task_set[i].initial_release)*0.001,&(user_param.initial_release));
    double_to_timespec((double)(task_set[i].wcet)*0.001,&(user_param.wcet));
    dword_to_dword_ts(task_set[i].dword,&(user_param.dword));
    user_param.name = task_set[i].name;
    CHK( pthread_attr_setappschedparam (&attr, &user_param, sizeof(user_param)) );
    param.sched_priority = MAIN_PRIO - 1;
    CHK( pthread_attr_setschedparam (&attr, &param) );
    CHK( pthread_create (&(prelude_threads[i]), &attr, pack, &(task_set[i])));
  }
 
  kill(0, END_OF_INIT);
  
  CHK( pthread_join (sched, NULL) );
 
  /* Clean up */
  for (i=0; i<task_number; i++)
    free_task(&(task_set[i]));
  free(task_set);
 
  return 0;
}
